 /********************************************************************
*	A9112F4_CONFIG.h
*	RF Chip-A9112F4	/ A9109-F4	Configure Definitions
*
*	This file provides the constants associated	with the
*	AMICCOM	A9112F4	/ A9109-F4 device.
*
********************************************************************/
#ifndef	_A9112F4_CONFIG_h_
#define	_A9112F4_CONFIG_h_



#ifdef _A9112F4_Function_C_
 
	
		#ifdef RF_DR10Kbps_50KIFBW 
				//915MHz, 10kbps (IFBW = 50KHz, Fdev = 18.75KHz), Crystal=12.8MHz
				const Uint8	code ID_Tab[8]={0x34,0x75,0xC5,0x8C,0xC7,0x33,0x45,0xE7};	//ID code
				const Uint8	HopTab[] = {0,1,2};	//hopping channel
				const Uint8	code MasterFreq_Tab[]=
				{		 
						0x8D, 0x18, 0x0A,  //CH0, freq 903.001MHz
						0x8E, 0xF8, 0x0A,  //CH1, freq 915.001MHz
						0x90, 0xD8, 0x0A,  //CH2, freq 927.001MHz
						
						0x8E, 0x08, 0x0A,  //CH3, freq 909.001MHz
						0x8F, 0xE8, 0x0A,  //CH4, freq 921.001MHz
					
						0x8D, 0x90, 0x0A,  //CH5, freq 906.001MHz
						0x8E, 0x80, 0x0A,  //CH6, freq 912.001MHz
						0x8F, 0x70, 0x0A,  //CH7, freq 918.001MHz
						0x90, 0x60, 0x0A,  //CH8, freq 924.001MHz
						
						0x8D, 0x40, 0x0A,  //CH9, freq 904.001MHz
						0x8D, 0xB8, 0x0A,  //CH10, freq 907.001MHz
						0x8E, 0x30, 0x0A,  //CH11, freq 910.001MHz
						0x8E, 0xA8, 0x0A,  //CH12, freq 913.001MHz

						0x8F, 0x20, 0x0A,  //CH13, freq 916.001MHz
						0x8F, 0x98, 0x0A,  //CH14, freq 919.001MHz
						0x90, 0x10, 0x0A,  //CH15, freq 922.001MHz

						
					
						
				};
				const Uint8	code SlaveFreq_Tab[]=
				{
						0x8D, 0x1C, 0x0A,  //CH0, freq 903.101MHz
						0x8E, 0xFC, 0x0A,  //CH1, freq 915.101MHz
						0x90, 0xDC, 0x0A,  //CH2, freq 927.101MHz
					
						0x8E, 0x08, 0x0A,  //CH3, freq 909.101MHz
						0x8F, 0xE8, 0x0A,  //CH4, freq 921.101MHz
					
						0x8D, 0x94, 0x0A,  //CH5, freq 906.101MHz
						0x8E, 0x84, 0x0A,  //CH6, freq 912.101MHz
						0x8F, 0x74, 0x0A,  //CH7, freq 918.101MHz
						0x90, 0x64, 0x0A,  //CH8, freq 924.101MHz
						
						0x8D, 0x44, 0x0A,  //CH9, freq 904.101MHz
						0x8D, 0xBC, 0x0A,  //CH10, freq 907.101MHz
						0x8E, 0x34, 0x0A,  //CH11, freq 910.101MHz
						0x8E, 0xAC, 0x0A,  //CH12, freq 913.101MHz

						0x8F, 0x24, 0x0A,  //CH13, freq 916.101MHz
						0x8F, 0x9C, 0x0A,  //CH14, freq 919.101MHz
						0x90, 0x14, 0x0A,  //CH15, freq 922.101MHz
				};

		#endif
	

		#ifdef RF_DR100Kbps_100KIFBW
				//915MHz, 100kbps (IFBW = 100KHz, Fdev = 37.5KHz), Crystal=12.8MHz
				const Uint8	code ID_Tab[8]={0x34,0x75,0xC5,0x8C,0xC7,0x33,0x45,0xE7};	//ID code
				const Uint8	HopTab[] = {0,1,2};	//hopping channel
				const Uint8	code MasterFreq_Tab[]=
				{
						0x8D, 0x18, 0x0A,  //CH0, freq 903.001MHz
						0x8E, 0xF8, 0x0A,  //CH1, freq 915.001MHz
						0x90, 0xD8, 0x0A   //CH2, freq 927.001MHz
				};
				const Uint8	code SlaveFreq_Tab[]=
				{
						0x8D, 0x20, 0x0A,  //CH0, freq 903.201MHz
						0x8F, 0x00, 0x0A,  //CH1, freq 915.201MHz
						0x90, 0xE0, 0x0A   //CH2, freq 927.201MHz
				};

		#endif
				
		#ifdef RF_DR150Kbps_150KIFBW
				//915MHz, 150kbps (IFBW = 150KHz, Fdev = 56.25KHz), Crystal=19.2MHz
				const Uint8	code ID_Tab[8]={0x34,0x75,0xC5,0x8C,0xC7,0x33,0x45,0xE7};	//ID code
				const Uint8	HopTab[] = {0,1,2};	//hopping channel
				const Uint8	code MasterFreq_Tab[]=
				{
						0x5E, 0x10, 0x06,  //CH0, freq 903.001MHz
						0x5F, 0x50, 0x06,  //CH1, freq 915.001MHz
						0x60, 0x90, 0x06   //CH2, freq 927.001MHz
				};
				const Uint8	code SlaveFreq_Tab[]=
				{
						0x5E, 0x18, 0x06,  //CH0, freq 903.301MHz
						0x5F, 0x58, 0x06,  //CH1, freq 915.301MHz
						0x60, 0x98, 0x06   //CH2, freq 927.301MHz
				};

		#endif
	
		#ifdef RF_DR250Kbps_250KIFBW
				//915MHz, 250kbps (IFBW = 250KHz, Fdev = 93.75KHz), Crystal=16MHz
				const Uint8	code ID_Tab[8]={0x34,0x75,0xC5,0x8C,0xC7,0x33,0x45,0xE7};	//ID code
				const Uint8	HopTab[] = {0,1,2};	//hopping channel
				const Uint8	code MasterFreq_Tab[]=
				{
						0x70, 0xE0, 0x08,  //CH0, freq 903.001MHz
						0x72, 0x60, 0x08,  //CH1, freq 915.001MHz
						0x73, 0xE0, 0x08   //CH2, freq 927.001MHz
				};
				const Uint8	code SlaveFreq_Tab[]=
				{
						0x70, 0xF0, 0x08,  //CH0, freq 903.501MHz
						0x72, 0x70, 0x08,  //CH1, freq 915.501MHz
						0x73, 0xF0, 0x08   //CH2, freq 927.501MHz
				};
		#endif
	


#else
	extern const Uint8 code	ID_Tab[];
	extern const Uint8 HopTab[]; 
	extern const Uint8 code	MasterFreq_Tab[];
	extern const Uint8 code	SlaveFreq_Tab[];	
	
#endif
  
	
	
	
#endif